#!/bin/sh
KERN_VER=`uname -r | sed 's/BOOT//'`
DRIVER=sii6512
# CORE DRIVER is the same as DRIVER without the CONFIGURATION 
COREDRIVER=siirl
DRIVERCONFIG=meddley
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"
INIDIR=$PWD
$SETCOLOR_NORMAL
echo "########################################################"
echo "#         Silicon Image SATARaid controller            #"
echo "#               RedHatLinux  Driver                    #"
echo "########################################################"
echo ""
echo "Detected  $KERN_VER  version of kernel"

echo "MUST BE ROOT TO RUN THIS PROGRAM"
echo "type any char to continue"
read nothing

echo "Trying to find the correct driver for kernel $KERN_VER ..."
mkdir -p /root/$DRIVER
cd       /root/$DRIVER
cp   -fu $INIDIR/modules.cgz  modules.cgz
gzip -dc modules.cgz > modules.cpio
cpio -idumv < modules.cpio
if [ ! -d $KERN_VER ];then
    $SETCOLOR_FAILURE
    echo ""
    echo "##########################################################"
    echo "# SiI Driver for this kernel not found. Aborting...      #"
    echo "##########################################################"
    $SETCOLOR_NORMAL
    echo ""
    exit 1
fi

echo "Copying 'inf'    files TO WORKING DIRECTORY"
cp  -fu  $INIDIR/modules.inf /root/$DRIVER/$KERN_VER
cp  -fu  $INIDIR/driver.inf /root/$DRIVER/$KERN_VER
echo "Copying 'config' files TO WORKING DIRECTORY"
cp  -fu  $INIDIR/$DRIVERCONFIG.c /root/$DRIVER/$KERN_VER
echo "Copying cleanmodconf TO WORKING DIRECTORY"
rm -rf /root/$DRIVER/$KERN_VER/cleanmodconf
cp    -fu $INIDIR/cleanmodconf /root/$DRIVER/$KERN_VER/

echo "Copying 'utilities'  files TO WORKING DIRECTORY"
cp  -fu  $INIDIR/merge.gz /root/$DRIVER/$KERN_VER
cp  -fu  $INIDIR/parse.gz /root/$DRIVER/$KERN_VER
#cp  -fu  $INIDIR/cc1  /root/$DRIVER/$KERN_VER

# build driver and install
cd $KERN_VER

echo "gunziping utilities...."
gunzip -rf merge
gunzip -rf parse 
#gunzip cc1

rm -rf /lib/modules/$KERN_VER/kernel/drivers/scsi/$DRIVER.o
echo "Parsing configuration file "
chmod +x parse
./parse -w -c -o ./$DRIVERCONFIG.o ./$DRIVERCONFIG.c
echo "Merging configuration file "
chmod +x merge
./merge -r -nostartfile -nostdlib -o satadriver.o $COREDRIVER.o $DRIVERCONFIG.o
echo "Copying driver to /lib/modules/$KERN_VER/kernel/drivers/scsi/$DRIVER.o"
rm -rf $DRIVER.o
cp -fu ./satadriver.o /lib/modules/$KERN_VER/kernel/drivers/scsi/$DRIVER.o
rm -rf ./satadriver.o
rm -rf ./$DRIVERCONFIG.o
rm -rf ./$COREDRIVER.o

################################################### 
#modify /etc/modules.conf file
echo "current dir is $PWD. MODIFYING /etc/modules.conf"
if [ -f /etc/rc.modules.bak ]; then
echo "/etc/modules.conf already backep up"
else
cp /etc/modules.conf /etc/modules.conf.bak
fi

cp /etc/modules.conf tempf 
source /root/$DRIVER/$KERN_VER/cleanmodconf
rm -rf tempf
#echo "current dir is $PWD ADDING TO /etc/modules.conf"
mv /etc/modules.conf tempf
cat tempf modules.inf >> /etc/modules.conf
rm -rf tempf
#################################################

$SETCOLOR_FAILURE
echo "#####################################################################"
echo "# A BOOTABLE software driver gets compiled with the kernel image    #"
echo "# A non-bootable software driver gets loaded as a module            #"
$SETCOLOR_SUCCESS
echo "# If your are installing 'NON-BOOTABLE' SATA DRIVES type 'N' (cr)   #"   
echo "# else you want to BOOT from the SATA DRIVES .. Type any character  #"
echo "#                                               to continue         #" 

$SETCOLOR_FAILURE
echo "#####################################################################"
$SETCOLOR_NORMAL
read bootable 
echo -n "$bootable" | grep "N"
if [ "$?" -eq 0 ];then
   echo "exiting.. installation complete"
   exit 0
fi
echo -n "$bootable" | grep "n"
if [ "$?" -eq 0 ];then
   echo "exiting.. installation complete"
   exit 0
fi


#create initrd image
INITRD_NAME=/boot/initrd-$KERN_VER.$DRIVER

#echo "/sbin/depmod -ae System.map"
#/sbin/depmod -ae System.map

rm -rf $INITRD_NAME
echo "/sbin/mkinitrd -f -v $INITRD_NAME $KERN_VER"

/sbin/mkinitrd -f -v $INITRD_NAME $KERN_VER
#check for lilo 

echo "deleting loadable module $DRIVER.o (not needed)"
rm -rf /lib/modules/$KERN_VER/kernel/drivers/scsi/$DRIVER.o

$SETCOLOR_FAILURE
echo "INITRD_NAME is $INITRD_NAME"
echo "##########################################################"
echo "#  The next section will modify the boot loader           "
echo "#  If you prefer to do it manually please exit now        "
echo "#  The boot configuration file in use will be backep up   "
echo "##########################################################"
$SETCOLOR_NORMAL
echo "type any character to continue"
read nothing

if [ -f /etc/lilo.conf ];then
    echo "LILO boot loader detected..."
    sed '/initrd=\/boot\/initrd-'$KERN_VER'.img''$/c\
    initrd=/boot/initrd-'$KERN_VER'.'$DRIVER'' /etc/lilo.conf > /tmp/lilo.tmp
    mv -f /etc/lilo.conf /etc/lilo.conf.old
    mv -f /tmp/lilo.tmp /etc/lilo.conf
 else
    echo "GRUB boot loader detected..."
    target=`/bin/awk '/vmlinuz-'$KERN_VER' / {print $2}' /boot/grub/grub.conf|sed 's/vmlinuz/initrd/'`
    sed '/initrd \/initrd-'$KERN_VER'.img''$/c\
    initrd '$target'.'$DRIVER'' /boot/grub/grub.conf > /tmp/grub.tmp
    mv -f /boot/grub/grub.conf /boot/grub/grub.conf.old
    mv -f /tmp/grub.tmp /boot/grub/grub.conf
fi

if [ -f /etc/lilo.conf ];then
/sbin/lilo
fi

$SETCOLOR_FAILURE
echo "INITRD_NAME is $INITRD_NAME"
echo "################################################################"
echo "#  Make sure Lilo and/or GRUB config file are correct           "
echo "#  Run Lilo if again necessary. Please inspect files visually   "
$SETCOLOR_SUCCESS

echo "$DRIVER is now inside the bootable kernel image"


#output result
$SETCOLOR_SUCCESS
echo ""
echo "##########################################################"
echo "#        SiI driver installed on your system             #"
echo "##########################################################"
echo ""
echo "  Created image:  $INITRD_NAME"
echo ""
echo "  old /etc/modules.conf was backep up to /etc/modules.conf.bak"
echo "  Please Manually check /etc/modules.conf to make sure is OK"
echo "                  check lilo.conf and grub.conf             "
echo "  To test current VERSION of driver.. 'reboot'"
$SETCOLOR_NORMAL
 
echo "########################################################"
echo "#  Silicon Image, Inc (C) 2003                         #"
echo "########################################################"
