#!/bin/sh
KERN=`uname -r | sed 's/BOOT//'`
KERN_VER=$1
DRIVER=sii6512
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"
INIDIR=$PWD
SOURCE=$2
$SETCOLOR_NORMAL
echo "########################################################"
echo "#         Silicon Image SATARaid controller            #"
echo "#               RedHatLinux  Driver                    #"
echo "########################################################"
echo ""
echo "you are running $KERN version of kernel"
$SETCOLOR_WARNING
echo "Trying to find the correct driver for kernel $KERN_DIR"
echo " Will look for directory /root/$DRIVER/$KERN_DIR on the floppy"
$SETCOLOR_NORMAL
echo "MUST BE ROOT TO RUN THIS PROGRAM"
echo "add 'smp' or 'custom' if necessary."
echo "e.g.  'sh ./load.sh 2.4.18-14 smp' "
echo "Type any char to continue"
read nothing

echo "installing.."

rm -rf /lib/modules/$KERN_VER/kernel/drivers/scsi/$DRIVER.o
echo "Copying driver from $SOURCE to /lib/modules/$KERN_VER/kernel/drivers/scsi/$DRIVER.o"
cp -fu $SOURCE/$DRIVER.o /lib/modules/$KERN_VER/kernel/drivers/scsi/$DRIVER.o
ls -al /lib/modules/$KERN_VER/kernel/drivers/scsi/sii*
insmod $DRIVER
cat /proc//scsi/SiI6512/*

$SETCOLOR_SUCCESS
echo ""
echo "###################################################################"
echo "#        SiI loadable driver installed on your system             #"
echo "###################################################################"
echo "  To test current VERSION of driver.. 'reboot'"
echo "  Device should be something like /dev/sda or /dev/sdb,           "
echo " "
$SETCOLOR_NORMAL
 
echo "########################################################"
echo "#  Silicon Image, Inc (C) 2003                         #"
echo "########################################################"
