#!/bin/sh
KERN=`uname -r | sed 's/BOOT//'`
KERN_VER=$1
KERN_DIR=$1$4
DRIVER=sii6512
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"
INIDIR=$PWD

# changes depending when your run
# e.g. /mnt/sysimage/root at fresh install time
#      or /root if run after installation
# WKR=/root
# WKR =/mnt/sysimage/root
WK=$2
WKR=$2root
SUSE=$3

$SETCOLOR_NORMAL
echo "########################################################"
echo "#         Silicon Image SATARaid controller            #"
echo "#               RedHatLinux  Driver                    #"
echo "########################################################"
echo ""

echo "you are running $KERN  version of kernel (it may not matter)"
$SETCOLOR_WARNING
echo "Trying to find the correct driver for kernel $KERN_DIR"
echo "              THIS IS THE TARGET KERNEL"
$SETCOLOR_NORMAL
echo "MUST BE ROOT TO RUN THIS PROGRAM"
#echo "add 'smp' or 'custom' if necessary."
echo "Current working directory will be $WKR root if you have not rebooted"
#echo "e.g.  'sh ./setup-update smp' "
echo "Type any char to continue"
read nothing

echo "installing.."

mkdir -p $WKR/$DRIVER
cd       $WKR/$DRIVER
cp    $INIDIR/$SUSE/$DRIVER.o $PWD 
echo  "copying $INIDIR/$SUSE/$DRIVER.o $PWD "
cp -f ./$DRIVER.o /lib/modules/$KERN_DIR/kernel/drivers/scsi/$DRIVER.o

echo "Modifying /etc/sysconfig/kernel to include sii6512"
if [ -f /etc/sysconfig/kernel ];then
    echo "file /etc/sysconfig/kernel detected..."
    sed -f $INIDIR/addsii.sed /etc/sysconfig/kernel > /tmp/ker.tmp
    echo "----------------------------------ORIGINAL FILE --------------------------------------"
    cat /etc/sysconfig/kernel
    echo "---------------------------------NEW KERNEL FILE -------------------------------------"
    cat /tmp/ker.tmp
    echo "--------------------------------------------------------------------------------------"
    echo ""
    echo "Type any char to continue.."
    read nothing
    mv -f /etc/sysconfig/kernel /etc/sysconfig/kernel.old
    mv -f /tmp/ker.tmp  /etc/sysconfig/kernel
else
    $SETCOLOR_FAILURE
    echo "FATAL error.. file /etc/sysconfig/kernel NOT FOUND.."
    read nothing
fi

mkinitrd 
echo "Type any character to continue.."
read nothing

echo "$DRIVER is now inside the bootable kernel image"

$SETCOLOR_WARNING
echo "##########################################################"
echo "#       EJECT FLOPPY                                     #" 
echo "##########################################################"

#output result
$SETCOLOR_SUCCESS
echo ""
echo "##########################################################"
echo "#        SiI driver installed on your system             #"
echo "##########################################################"
echo ""
$SETCOLOR_NORMAL
 
echo "########################################################"
echo "#  Silicon Image, Inc (C) 2003                         #"
echo "########################################################"
